varying vec2 texcoord;

float phaseg(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

#include "/lib/sky_function.glsl"
#ifdef CLOUDS

    #if CLOUD_STYLE == 2

        #include "/lib/clouds/clouds_loop_a.glsl"
    #else
        #ifdef ALT_CLOUDS
            #include "/lib/clouds/clouds_bloop_a.glsl"
        #else
            #include "/lib/clouds/clouds_bloop.glsl"
        #endif
    #endif
#endif
#ifndef CLOUDS

float simpleclouds(vec3 worldPos)
{
    vec3 worldDir = normalize(worldPos);
    vec2 rPos = worldDir.xz * (120.0 / worldDir.y) + cameraPosition.xz;
    float dist = distance(rPos, cameraPosition.xz);

    vec2 cloudOffset = vec2(mod(-cloudTime / 12.0, 256.0), 0.33);
    vec2 pos = (mod(rPos, 3072.0) + vec2(0.0, 4.0)) / 12.0 - cloudOffset;
    pos /= 256.0;

    float cloud = (texture(depthtex1, pos).x + rainStrength) / (1.0 - rainStrength * 0.8);
    float scattering = luma(sunLight * 0.5 + atmosphereUp) * cloud * 0.05;

    float attenuation = exp(-dist * 0.0015);
    float result = scattering * clamp(attenuation, 0.0, 1.0);

    return result;
}
#endif

void main()
{
    /* DRAWBUFFERS:6 */
    vec3 viewVector = mapUVToSphere(texcoord.xy);

    vec3 skyComp = clamp(fogAtmosphereALT3(viewVector), 0, 1000);

#ifdef CLOUDS
    //
    #if CLOUD_STYLE == 2
    vec4 cloud = renderClouds(1, viewVector, skyComp.rgb * 0, false, 0, false);
    #else
        #ifdef ALT_CLOUDS
    vec4 cloud = renderClouds(1, viewVector, skyComp.rgb * 0, false, 0, false);

        #else
    vec4 cloud = renderClouds(1, viewVector, skyComp.rgb * 0, false);

        #endif
    #endif

    gl_FragData[0].a = dot(cloud.rgb, vec3(0.299, 0.587, 0.114)) * 1 - cloud.a;
#else

    gl_FragData[0].a = simpleclouds(viewVector);

#endif

    gl_FragData[0].rgb = skyComp;
}
